
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE constants.js --------------------------------------------------------------------------->

var PlayState =
{
	Undefined:		0,
    Stopped:        1,
    Paused:         2,
    Playing:        3,
    ScanForward:    4,
    ScanReverse:    5,
    Buffering:		6,
    Waiting:		7,
    MediaEnded:		8,
    Transitioning:	9,
    Ready:			10

}

var OpenState =
{
	Undefined:					0,
	PlaylistChanging:			1,
	PlaylistLocating:			2,
	PlaylistConnecting:			3,
	PlaylistLoading:			4,
	PlaylistOpening:			5,
	PlaylistOpenNoMedia:		6,
	PlaylistChanged:			7,
	MediaChanging:				8,
	MediaLocating:				9,
	MediaConnecting:			10,
	MediaLoading:				11,
	MediaOpening:				12,
	MediaOpen:					13,
	BeginCodecAcquisition:		14,
	EndCodecAcquisition:		15,
	BeginLicenseAcquisition:	16,
	EndLicenseAcquisition:		17,
	BeginIndividualization:		18,
	EndIndivididualization:		19,
	MediaWaiting:				20,
	OpeningUnknownURL:			21
}
	


function GetPlayStateName(state)
{
	switch (state)
	{
		case PlayState.Undefined:
			return "Undefined";
		case PlayState.Stopped:
			return "Stopped";
		case PlayState.Paused:
			return "Paused";
		case PlayState.Playing:
			return "Playing";
		case PlayState.ScanForward:
			return "ScanForward";
		case PlayState.ScanReverse:
			return "ScanReverse";
		case PlayState.Buffering:
			return "Buffering";
		case PlayState.Waiting:
			return "Waiting";
		case PlayState.MediaEnded:
			return "MediaEnded";
		case PlayState.Transitioning:
			return "Transitioning";
		case PlayState.Ready:
			return "Ready";
		default:
			return "Uknown State Type";
	}
}

// ENDFILE constants.js ----------------------------------------------------------------------------->

// BEGINFILE ScriptParse.js ------------------------------------------------------------------------->

function ScriptParser()
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.ParseScriptFromStream = function(sType, sParam)
	{
		this.Debug("ParseScriptFromStream called: ScriptType: " + sType + ", ScriptParam: " + sParam);
		switch(sType)
		{
			case "MSLiveEvent":
//				alert('this eventtype MSLiveEvent is not supported');
//				break;
			case "MSL":
				eval("this." + sParam + "");
				break;
		}
	}

	// this is the one which notifies to all interested Areas
	this.NotifyScriptEvent = function(oArgs)
	{
		this.Debug("NotifyScriptCommand called");
		MainHelper.EventScript.Post(oArgs);
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "ScriptParser: " + str);
	}
	
	
	// new event stuff below this------------------------------------------------------------------------
	// HE('EventType', Param1, Param2...);
	// this function is directly called by the mac player
	this.HE = function()
	{
		this.Debug("HE called");
		if (arguments.length < 1)
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "The event must be of the form " + 
				"HE('EventType', [args....])");
			return;
		}
		
		var command = arguments[0];
		switch (command)
		{
			case "S":
				if (arguments.length < 2)
				{
					SfDebug.DPF(SfDebug.ErrMsgCritical, "ShowSlide wrong arguments: " + arguments);	
					return;
				}
				var slideNumber = Number(arguments[1]);
				var args = MainHelper.CreateShowSlideEventArgs(slideNumber);
				if (MainHelper.MaxSlideTimings < slideNumber)
				{
					MainHelper.KeepAddingToSlideTimings(args);
					MainHelper.DynamicAdd = true;
				}
				else
				{
					MainHelper.DynamicAdd = false;
				}
				
				MainHelper.PresentationEnded = false;
				this.NotifyScriptEvent(args);
				break;
			case "E":
				var args = new Object();
				args.Command = SfScriptCommandType.EndPresentation;
				if (MainHelper.Presentation.DoReporting == true)
				{
					this.ReportEndPresentationEvent();
				}
				this.NotifyScriptEvent(args);
				break;
		}
	} 
	
	this.ReportEndPresentationEvent = function()
	{
		this.Debug("ReportEndPresentationEvent");
		var imageSource = Util.GetDocumentBase() + "Reporting/ReportEndPresentationEvent.aspx?";
		var frameLoader = new FrameLoader(imageSource);
		frameLoader.Load();
	}

}

// ENDFILE ScriptParse.js --------------------------------------------------------------------------->


// BEGINFILE PlayerArea.js -------------------------------------------------------------------------->

PlayerArea.prototype = new AreaBase();
function PlayerArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
	this.PlayerType = "Unknown"; // should override in derived classs
	this.ScriptParser = new ScriptParser();
	this.AttemptNumber = 0;
	this.StatusFrameLoader = null;
	this.PlayFrom = -1;
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "PlayerArea: PlayerType = " + this.PlayerType + ": " + str);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad called");
		// delegate to the other method because
		// we need to override onload for 
		// the playerarea for mac
		this.DoOnLoad();
	}
	
	this.DoOnLoad = function()
	{
		this.Debug("DoOnLoad called");
		this.CheckPresentationStatus();
	}
	
	this.CheckPresentationStatus = function()
	{
		this.Debug("CheckPresentationStatus called");
		if (MainHelper.Presentation.IsStandAlone == true)
		{
			this.StartPlaying();
			return;
		}
		var status = MainHelper.Presentation.Status;

		switch (status)
		{
			case PresentationStatus.CaptureInProgress:
			case PresentationStatus.ReplayReady:
				this.StartPlaying();
				return;
			case PresentationStatus.Offline:
			case PresentationStatus.CaptureEnded:
				return;
			case PresentationStatus.Locked:
				alert('This presentation is locked and can not be viewed');
				break;
			case PresentationStatus.Test:
			case PresentationStatus.NotReady:
			case PresentationStatus.CaptureReady:
				this.DoNotReadyStuff();
				return;
			default:
				alert('Unknown Presentation Status: ' + MainHelper.Presentation.Status);
				return;
		}
		
	}
	
	this.GetEmbeddedPlayer = function()
	{
		var helper = new FrameHelper();

		return (helper.PlayerDetect.GetPlayerType() == PlayerType.WM64Lite ? SfDOM.FindElementFromID(document, "MacPlayer") : SfDOM.FindElementFromID(document, "EmbeddedPlayer") );
	}
	
	this.DoNotReadyStuff = function()
	{
		var image = SfDOM.FindElementFromID(document, "PlayerPresentationNotStarted");
		
		if (image)
		{
			image.style.display = '';
			var embeddedPlayer = this.GetEmbeddedPlayer();
		
			if (embeddedPlayer)
			{
				embeddedPlayer.style.left = "-5000px";
			}
			else
			{
				this.Debug("embedded player not found");
			}
		}
		else
		{
			this.Debug("not started image not found");
		}
		
		this.StatusFrameLoader = new PresentationStatusChecker(this.GetFrameSource());
		this.KeepChecking();
	}
	
	this.GetFrameSource = function()
	{
		if (MainHelper.Presentation.IsStandAlone == true)
		{
			return Util.GetDocumentBase() +
				"CurrentStatus.html";
		}
		else
		{
			return Util.GetDocumentBase() + 
				"StatusChange/StatusChangeMonitor.aspx?" + SfRequestVariables.PresentationID + "=" + MainHelper.Presentation.PresentationID;
		}	
	}

	this.KeepChecking = function()
	{
		++this.AttemptNumber;

		this.Debug("KeepChecking called , attempt: " + this.AttemptNumber);
		
		this.StatusFrameLoader.Check();
	}
	
	this.NotReady = function(checkInterval)
	{
		this.Debug("NotReady called");
		window.setTimeout(this.Container + ".KeepChecking()", checkInterval);
//		window.setTimeout(this.Container + ".KeepChecking()", 15000);
	}
	
	this.Ready = function(currentSlideNumber)
	{
		this.Debug("Ready called, slideNumber: " + currentSlideNumber);

		var image = SfDOM.FindElementFromID(document, "PlayerPresentationNotStarted");
		if (image)
		{
			image.style.display = 'none';
		}
		var embeddedPlayer = this.GetEmbeddedPlayer();
		if (embeddedPlayer)
		{
			embeddedPlayer.style.left = "0";
		}
		else
		{
			this.Debug("Embedded player not found");
		}

		this.AddSlideTimingsIfRequired(currentSlideNumber);
		
		MainHelper.Presentation.Status = PresentationStatus.CaptureInProgress;
		MainHelper.EventDataAvailable.Post(new SfEventArgs());

		if (MainHelper.Presentation.DoReporting == true)
		{
			this.ReportPresentationStatusChangedToLive();
		}
		
		this.StartPlaying();
	}
	
	this.ReportPresentationStatusChangedToLive = function()
	{
		this.Debug("ReportPresentationStatusChangedToLive");
		var imageSource = Util.GetDocumentBase() + "Reporting/ReportStatusChangedToLive.aspx?";
		
		var frameLoader = new FrameLoader(imageSource);
		frameLoader.Load();
	}
	
	this.AddSlideTimingsIfRequired = function(currentSlideNumber)
	{
		this.Debug("AddSlideTimingsIfRequired()");
		
		if (currentSlideNumber == -1)
		{
			this.Debug("No need to add");
			return;
		}
		
		var args = MainHelper.CreateShowSlideEventArgs(currentSlideNumber);
		MainHelper.KeepAddingToSlideTimings(args);
	
	}
	
	this.StartPlaying = function()
	{
		this.Debug("StartPlaying called");
		
		this.SetupPlayer();
	}
	
	this.ResizeWindow = function()
	{
		this.Debug("ResizeWindow called: ViewerWidth: " + this.ViewerWidth + ", ViewerHeight: " + this.ViewerHeight);
		if (this.ViewerWidth == -1 || this.ViewerHeight == -1)
		{
			this.Debug("no resize needed");
			return;
		}
		var extraWidth = MainHelper.GetFrameExtraWidth();
		var extraHeight = MainHelper.GetFrameExtraHeight();
		window.resizeTo(this.ViewerWidth + extraWidth, this.ViewerHeight + extraHeight);		
	}

	this.CalculateSlideNumberToShow = function(time)
	{
		if (time < 0)
		{
			return 0;
		}
		var i;
		var lowerBound = 0;
		var maxTimings = MainHelper.MaxSlideTimings;
		if (!maxTimings)
		{
			return 0;
		}
		for (i=0; i<maxTimings; ++i)
		{
			var upperBound = MainHelper.Presentation.SlideTimings[i].Time;
			this.Debug("lower: " + lowerBound + ", upper: " + upperBound + ", time: " + time);
			if (time >= lowerBound && time < upperBound)
			{
				return i;
			}
			lowerBound = upperBound;
		}
		return maxTimings;
	}
}

// ENDFILE PlayerArea.js ---------------------------------------------------------------------------->


